-- Visby class Litoral Combat Ship - Mod by Markindel (www.news3d.eu)

mount_vfs_model_path	(current_mod_path.."/Shapes")
mount_vfs_texture_path  (current_mod_path.."/Textures/HMS_Visby.zip")

GT = {};
GT_t.ws = 0;

set_recursive_metatable(GT, GT_t.generic_ship)

GT.visual = {}
GT.visual.shape = "HMS_Visby"
GT.visual.shape_dstr = "HMS_Visby_sunk"

-- Turbine
GT.turbine = false;
-- Turbine

-- Sound
GT.sound = {};

-- Engine params
GT.sound.engine = {};
GT.sound.engine.idle = "GndTech/BMPEngineIdle";
GT.sound.engine.max = "GndTech/BMPEngineMax";

GT.sound.engine.acc_start = "GndTech/BMPEngineAccStart";
GT.sound.engine.acc_end = "GndTech/BMPEngineAccEnd";

GT.sound.engine.idle_formula_gain = "0.625 x * 0.875 +";
GT.sound.engine.idle_formula_pitch = "0.4813 x * 0.8538 +";

GT.sound.engine.max_formula_gain = "0.75 x * 0.25 +";
GT.sound.engine.max_formula_pitch = "0.615 x * 0.507 +";

GT.animation_arguments.radar1_rotation = 11; --   1
GT.radar1_period = 3;
GT.animation_arguments.radar2_rotation = -1; --   2 
GT.animation_arguments.radar3_rotation = -1; --   3 
GT.animation_arguments.luna_lights = -1;

GT.life = 1000;
GT.mass = 9.59e+006;
GT.max_velocity = 70
GT.race_velocity = 25
GT.economy_velocity = 10.2889
GT.economy_distance = 1.1112e+007
GT.race_distance = 2.778e+006
GT.shipLength = 72 --172.8
GT.Width = 10,5 --15
GT.Height = 74.4 --37.2
GT.Length = 152.4 --172.8
GT.DeckLevel = 8

---- Primo valore    : avanti/indietro
---- Secondo valore: alto/basso
---- Terzo Valore    : destra/sinistra
---GT.X_nose = 75.7412
---GT.X_tail = -85.9824
GT.X_nose = 33.5
GT.X_tail = -34.00


GT.Tail_Width = 15
GT.Gamma_max = 0.35
GT.Om = 0.05
GT.speedup = 0.9
GT.R_min = 60
GT.distFindObstacles = 150

GT.numParking = 1
GT.Plane_Num_ = 0
GT.Helicopter_Num_ = 2

GT.airWeaponDist = 100000
GT.airFindDist = 150000

---GT.Landing_Point = {-44.0, 9.93, 0.0}
GT.Landing_Point = {-50.0, 9.50, 0.0}

GT.DM = {
    { area_name = "NOSE_R",			        area_arg = 70,	area_life = 110, area_fire = { pos = {57.0, 4.0, 5.0}, size = 0.8}},
    { area_name = "BORT_R",			        area_arg = 71,	area_life = 110, area_fire = { pos = {1.0,  1.0, 5.0}, size = 0.8}},
    { area_name = "KORMA_R", 		        area_arg = 72,	area_life = 110, area_fire = { pos = {-70.0, 2.0, 7.7}, size = 0.8}},
    { area_name = "NOSE_L", 		        area_arg = 73,	area_life = 110, area_fire = { pos = {50.0, 4.0, -5.0}, size = 0.8}},
    { area_name = "BORT_L", 		        area_arg = 74,	area_life = 110, area_fire = { pos = {0.0,  2.0, -8.0}, size = 0.8}},
    { area_name = "KORMA_R", 		        area_arg = 75,	area_life = 110, area_fire = { pos = {-70.0, 2.0, -7.7}, size = 0.8}},
   	{ area_name = "KORMA_L", 		        area_arg = 75,	area_life = 110, area_fire = { pos = {-60.0, 2.0, 0.0}, size = 0.8}},
	{ area_name = "NOSE_TOP",		        area_arg = 76,	area_life = 80,  area_fire = { pos = {41.5, 7.5, 0.0}, size = 0.5}},
--- { area_name = "RUBKA_TOP",		        area_arg = 77,	area_life = 100,},
	{ area_name = "RUBKA_TOP",		        area_arg = 77,	area_life = 100, area_fire = { pos = {7.0,  20.0, 0.0}, size = 0.8}},
	{ area_name = "HP",				        area_arg = 78,	area_life = 80,  area_fire = { pos = {-40.0, 7.6, 0.0}, size = 0.5}},
	{ area_name = "KORMA_BACK", 	        area_arg = 79,	area_life = 110, area_fire = { pos = {-85.7, 2.0, 0.0}, size = 0.5}},
	{ area_name = "KABINA",			        area_arg = 80,	area_life = 220, area_fire = { pos = {20.8, 18.0   , 0.0}, size = 1.5}},
	{ area_name = "BORT_TOP_BACK", 	        area_arg = 81,	area_life = 80,  area_fire = { pos = {-61.7, 5.9, 0.0}, size = 0.5}},
	{ area_name = "NADSTROYKA",		        area_arg = 82,	area_life = 220, area_fire = { pos = {-23.0, 12.0, 0.0}, size = 1.5}},
	{ area_name = "SUPERSTRUCTURE_Mid",	    area_arg = 83,	area_life = 320, area_fire = { pos = {5.6, 9.8, 0.0}, size = 1.5}},
	{ area_name = "KORMA_TOP", 		        area_arg = 84,	area_life = 40, area_fire = { pos = {-76.7, 3.4, 0.0}, size = 1.0}},
    { area_name = "TOWER_NOSE",		        area_arg = 97,	area_life = 60, area_fire = { pos = {55.2, 8.2, 0.0}, size = 0.5}},
	{ area_name = "TOWER_KORMA",          	area_arg = 98,	area_life = 60, area_fire = { pos = {-49.0, 3.5, 0.0}, size = 0.5}},
    { area_name = "ZA_R",			        area_arg = 99,	area_life = 27, area_fire = { pos = {3.7, 17.15, 6.25}, size = 0.5}},
    { area_name = "ZA_L",			        area_arg = 100,	area_life = 27, area_fire = { pos = {30.0,  12.0, 0.0}, size = 0.5}}, --- CIWS Prua
}


-- weapon systems
GT.WS = {}
local ws;
GT.WS.maxTargetDetectionRange = 450000;
GT.WS.radar_type = 102

--- Mini GUN di PRUA lato Destro Posteriore
ws = GT_t.inc_ws();
GT.WS[ws] = {}
GT.WS[ws].area = 'HP'
GT.WS[ws].center = 'Center_Tower_06'
GT.WS[ws].drawArgument1 = 21
GT.WS[ws].drawArgument2 = 22
--GT.WS[ws].angles = {
--					{math.rad(160), math.rad(-150), math.rad(-5), math.rad(70)},
--					};
GT.WS[ws].angles = {
                    {math.rad(-10), math.rad(-170), math.rad(-5), math.rad(40)},
                    };
GT.WS[ws].reference_angle_Y = math.rad(-90);					
__LN = add_launcher(GT.WS[ws], GT_t.LN_t.machinegun_12_7_M2);
__LN.BR[1].connector_name = 'POINT_GUN_11'
__LN.fireAnimationArgument = 123;

-----------------------------------------------------------------------------------------
--- Mini GUN di PRUA lato  Sinistro Posteriore
-- Nose Machineguns M2 .50cal
ws = GT_t.inc_ws();
GT.WS[ws] = {}
GT.WS[ws].area = 'HP'
GT.WS[ws].center = 'CENTER_TOWER_05'
GT.WS[ws].drawArgument1 = 41
GT.WS[ws].drawArgument2 = 42
--GT.WS[ws].angles = {
--					{math.rad(150), math.rad(-160), math.rad(-5), math.rad(70)},
--					};
GT.WS[ws].angles = {
                    {math.rad(170), math.rad(10), math.rad(-5), math.rad(40)},
                    };
GT.WS[ws].reference_angle_Y = math.rad(90);
__LN = add_launcher(GT.WS[ws], GT_t.LN_t.machinegun_12_7_M2);
__LN.BR[1].connector_name = 'POINT_GUN_04'
__LN.fireAnimationArgument = 120;
----------------------------------------------------------------------------------------

----------------------------------------------------------------------------------------
--- Mini GUN di PRUA lato  Sinistro Anteriore
-- Nose Machineguns M2 .50cal
ws = GT_t.inc_ws();
GT.WS[ws] = {}
GT.WS[ws].area = 'ZA_R'
GT.WS[ws].center = 'CENTER_TOWER_04'
GT.WS[ws].drawArgument1 = 49   ---- movimento dx/sx
GT.WS[ws].drawArgument2 = 50   ---- movimento alto/basso
--GT.WS[ws].angles = {
--					{math.rad(150), math.rad(-160), math.rad(-5), math.rad(70)},
--					};
GT.WS[ws].angles = {
                    {math.rad(170), math.rad(10), math.rad(-5), math.rad(40)},
                    };
GT.WS[ws].reference_angle_Y = math.rad(90);
__LN = add_launcher(GT.WS[ws], GT_t.LN_t.machinegun_12_7_M2);
__LN.BR[1].connector_name = 'POINT_GUN_02'
__LN.fireAnimationArgument = 119;
----------------------------------------------------------------------------------------

--- Mini GUN di PRUA lato Destro Anteriore

ws = GT_t.inc_ws();
GT.WS[ws] = {}
GT.WS[ws].area = 'ZA_L'
GT.WS[ws].center = 'CENTER_TOWER_013'
GT.WS[ws].drawArgument1 = 51    ---- movimento dx/sx
GT.WS[ws].drawArgument2 = 52    ---- movimento alto/basso 
--GT.WS[ws].angles = {
--					{math.rad(160), math.rad(-150), math.rad(-5), math.rad(70)},
--					};
GT.WS[ws].angles = {
                    {math.rad(-10), math.rad(-170), math.rad(-5), math.rad(40)},
                    };
GT.WS[ws].reference_angle_Y = math.rad(-90);					
__LN = add_launcher(GT.WS[ws], GT_t.LN_t.machinegun_12_7_M2);
__LN.BR[1].connector_name = 'POINT_GUN_03'
__LN.fireAnimationArgument = 118;




--[[
--- Mini GUN di PRUA lato Destro Posteriore
ws = GT_t.inc_ws();
GT.WS[ws] = {}
GT.WS[ws].area = 'HP'
GT.WS[ws].center = 'Center_Tower_06'
GT.WS[ws].drawArgument1 = 21
GT.WS[ws].drawArgument2 = 22
--GT.WS[ws].angles = {
--					{math.rad(160), math.rad(-150), math.rad(-5), math.rad(70)},
--					};
GT.WS[ws].angles = {
                    {math.rad(-10), math.rad(-170), math.rad(-5), math.rad(40)},
                    };
GT.WS[ws].reference_angle_Y = math.rad(-90);					
__LN = add_launcher(GT.WS[ws], GT_t.LN_t.machinegun_12_7_M2);
__LN.BR[1].connector_name = 'POINT_GUN_11'
__LN.fireAnimationArgument = 123;
--]]
----------------------------------------------------------------------------------
-- Artillery Guns
--------------  classe Spruance: Torretta Cannone di prua 
ws = GT_t.inc_ws();
GT.WS[ws] = {}
set_recursive_metatable(GT.WS[ws], GT_t.WS_t.ship_FMC5 )
GT.WS[ws].animation_alarm_state = {time = 1.5, arg = 30}   
GT.WS[ws].area = 'TOWER_NOSE'
GT.WS[ws].center = 'CENTER_TOWER_12'
GT.WS[ws].drawArgument1 = 0
GT.WS[ws].drawArgument2 = 1
GT.WS[ws].angles[1][1] = math.rad(170);
GT.WS[ws].angles[1][2] = math.rad(-170);
GT.WS[ws].LN[1].BR[1].connector_name = 'Point_Gun_01'
GT.WS[ws].LN[1].BR[1].recoilArgument = 33;
GT.WS[ws].LN[1].BR[1].recoilTime = 0.2;

----------------------------------------------------------------------------------
-- SAAB RBS15 MK3
-----------------------------------------------------------------------------------
local RBS15w = {
	category		= CAT_MISSILES,
	name			= "RBS15",
	user_name	 	= _("RBS15"),
	wsTypeOfWeapon  = {wsType_Weapon,wsType_Missile,wsType_AS_Missile,WSTYPE_PLACEHOLDER},
	Escort 			= 1, -- 0, --  0, 1 ou 3 ?? -- 0 - N/A, 1 - LA start, 2 - another LA, 3 - land
	-- 0 tir et oubli -- 1 guide
	Head_Type 		= 2, -- 5 -- 5 ou 7 ? -- InfraredSeeker = 1 -- ActiveRadar = 2; -- AntiRadar = 3; -- LaserHoming = 4; -- Autopilot = 5; -- SemiActiveRadar = 6; -- SemiAutoAT = 7;
	-- 5 tir et oubli -- 7 malutka
	sigma 			= {4, 4, 4}, -- the maximum error of sight in meters, the target coordinates. X Y Z
	M 				= 23.5,
	H_max 			= 250.0, -- Max Altitude
	H_min 			= 25, -- Min Altitude
	Diam 			= 760.0,
	Cx_pil 			= 2.0,
	D_max 			= 80000.0, 
	D_min 			= 8000.0,
	Head_Form 		= 1, -- 0 - hemispherical shape of the head, 1 - ogival 
	Life_Time 		= 600.0,
	Nr_max 			= 0.5, -- MAx G turn rate
	v_min 			= 170.0,
	v_mid 			= 200.0,
	Mach_max 		= 0.9,
	t_b 			= 0.0,
	t_acc 			= 5.0,
	t_marsh 		= 0.0,
	Range_max 		= 90000.0,
	H_min_t 		= 0.0,
	Fi_start 		= 1.0, -- tracking and viewing angle at start (rad)
	Fi_rak 			= 3.14152, -- max angle of target (rad)
	Fi_excort 		= 1.05, -- max angle missile vs target (rad)
	Fi_search 		= 99.9, -- max search angle (rad)
	OmViz_max 		= 99.9, -- max speed for target visibility 

	warhead 		= 
	{
		mass 					= 2573; 
		expl_mass 				= 513; 
		other_factors 			= {1, 1, 1};
		obj_factors 			= {1, 1};
		concrete_factors 		= {1, 1, 1};
		cumulative_factor 		= 3.0;
		concrete_obj_factor 	= 0.0;
		cumulative_thickness 	= 0.9;
		piercing_mass			= 0.0;
		caliber					= 150,
	},
---- Primo valore    : avanti/indietro
---- Secondo valore: alto/basso
---- Terzo Valore    : destra/sinistra
	Damage 			= 50, 
	exhaust 		= {0.9, 0.9, 0.85, 0.3},  -- Tail smoke color format {R, G, B, alpha}. All values from 0 to 1
---	X_back 			= -0.8, -- exhaust X
	X_back 			= 0.08, -- exhaust X
---	Y_back 			= 0.0,  -- exhaust Y
	Y_back 			= 3.0,  -- exhaust Y
	Z_back 			= 0.0,  -- exhaust Z
	Reflection 		= 0.015, -- radar reflection cross
	KillDistance 	= 0.0, -- this distance is used to fire a fuze // type 428 proximity fuze
	shape_table_data = 
	{
		{
			name	 = "RBS15";
			file  	 = "RBS15M";
			life  	 = 1;
			fire  	 = { 0, 1};
			username = "RBS15";
			index = WSTYPE_PLACEHOLDER;
		},
	}
}
declare_weapon(RBS15w)
	
GT_t.WS_t.ship_RBS15w = {} 
GT_t.WS_t.ship_RBS15w.angles = {
					{math.rad(45), math.rad(-45), math.rad(-10), math.rad(45)},
					};
GT_t.WS_t.ship_RBS15w.reference_angle_Z = math.rad(60);
GT_t.WS_t.ship_RBS15w.moveable = false
GT_t.WS_t.ship_RBS15w.LN = {}
GT_t.WS_t.ship_RBS15w.LN[1] = {}
GT_t.WS_t.ship_RBS15w.LN[1].type = 1
GT_t.WS_t.ship_RBS15w.LN[1].distanceMin = 8000
GT_t.WS_t.ship_RBS15w.LN[1].distanceMax = 80000
GT_t.WS_t.ship_RBS15w.LN[1].reactionTime = 10; -- Preload time 240s.
GT_t.WS_t.ship_RBS15w.LN[1].launch_delay = 5;
GT_t.WS_t.ship_RBS15w.LN[1].sound = { single_shot = "Weapons/MissileLaunch2", }
GT_t.WS_t.ship_RBS15w.LN[1].external_tracking_awacs = true
GT_t.WS_t.ship_RBS15w.LN[1].sensor = {}
set_recursive_metatable(GT_t.WS_t.ship_RBS15w.LN[1].sensor, GT_t.WSN_t[0])
GT_t.WS_t.ship_RBS15w.LN[1].PL = {}
GT_t.WS_t.ship_RBS15w.LN[1].PL[1] = {}
GT_t.WS_t.ship_RBS15w.LN[1].PL[1].ammo_capacity = 4
GT_t.WS_t.ship_RBS15w.LN[1].PL[1].type_ammunition = {4,4,11,121}
GT_t.WS_t.ship_RBS15w.LN[1].PL[1].name_ammunition = "P_15"
GT_t.WS_t.ship_RBS15w.LN[1].PL[1].reload_time = 1000000; -- never during the mission
GT_t.WS_t.ship_RBS15w.LN[1].BR = { {pos = {0, 0, 0} } }
----RBS15 Launchers  
----------------------------------------------------------------------------------
-- Harpoon
----------------  4 tubi di lancio dei missili Harpoon--------------------------------
ws = GT_t.inc_ws();
GT.WS[ws] = {}
set_recursive_metatable(GT.WS[ws], GT_t.WS_t.ship_RBS15w)   -----  Left
GT.WS[ws].animation_alarm_state = {time = 1.5, arg = 153} 
GT.WS[ws].area = 'KORMA_L';
GT.WS[ws].pos = {-83.594,7.002,-4.54}
GT.WS[ws].angles[1][1] = math.rad(180);
GT.WS[ws].angles[1][2] = math.rad(0);
GT.WS[ws].LN[1].PL[1].ammo_capacity = 4;
--GT.WS[ws].LN[1].show_external_missile = true
GT.WS[ws].LN[1].BR = {
		{connector_name = 'Rocket_Point_123', drawArgument = 153},
		{connector_name = 'Rocket_Point_124', drawArgument = 154},
		{connector_name = 'Rocket_Point_125', drawArgument = 155},
		{connector_name = 'Rocket_Point_126', drawArgument = 156},
}

--------------------------------------------------------------------------------------

ws = GT_t.inc_ws();
GT.WS[ws] = {}
set_recursive_metatable(GT.WS[ws], GT_t.WS_t.ship_RBS15w)    ------ Right
GT.WS[ws].animation_alarm_state = {time = 1.5, arg = 157} 
GT.WS[ws].area = 'KORMA_L';
GT.WS[ws].pos = {-85.594,7.002,-4.54}
GT.WS[ws].angles[1][1] = math.rad(0);
GT.WS[ws].angles[1][2] = math.rad(-180);
GT.WS[ws].LN[1].PL[1].ammo_capacity = 4;
--GT.WS[ws].LN[1].show_external_missile = true
GT.WS[ws].LN[1].BR = {
		{connector_name = 'Rocket_Point_127', drawArgument = 157},
		{connector_name = 'Rocket_Point_128', drawArgument = 158},
		{connector_name = 'Rocket_Point_129', drawArgument = 159},
		{connector_name = 'Rocket_Point_130', drawArgument = 160},
}

------------------------------------------------------------------------------------


------------------------------------------------------------------------------------

GT.Name = "HMS_Visby"
GT.DisplayName = _("HSwMS Visby K31")
GT.Rate = 4000

GT.Sensors = {  OPTIC = {"long-range naval optics", "long-range naval LLTV", "long-range naval FLIR",},
                RADAR = {
                    "Patriot str",
                    "ticonderoga search radar",
                }
            };

GT.DetectionRange  = GT.airFindDist;
GT.ThreatRange = GT.airWeaponDist;
GT.Singleton   ="no";
GT.mapclasskey = "P0091000067";
GT.attribute = {wsType_Navy,wsType_Ship,wsType_ArmedShip,wsType_GenericLightArmoredShip,

                    "Cruisers",
                    "RADAR_BAND1_FOR_ARM",
                    "DetectionByAWACS",
				};
GT.Categories = {
					{name = "Armed Ship"},
					{name = "HelicopterCarrier"}
				};
				
add_surface_unit(GT)